	subroutine READIN(iout, idbg, ipost, Ne, Nn, Nb, Nm, Ng, NnNd, ldw, &
			Sx, ie, &
			x, C, D, xg, wg, BCe, BCi, BCvalue, BCtype, Soe, &
			vA, vB, ipar, fpar, &
			rA, rB, &
			cA, cB, &
			lastA, lastB)
! read input

	implicit none
	integer iout, idbg, ipost
	integer Ne, Nn, Nb, Nm, Ng, NnNd, ldw	! array parameters
	integer lastA, lastB
	real*8 Sx
	integer ipar(16)			! bCGstab integer parameters array
	real*8 fpar(16)				! bCGstab real    parameters array
	integer BCe(Nb,3), BCi(Nb)		! BC element and local element face numbers
	integer rA(Nn+1), rB(Nn+1)		! global  arrays (compact rows)
	integer cA(NnNd), cB(NnNd)		! global  arrays (compact columns)
	real*8 BCvalue(Nb,2)			! BC value (jx_bar, qx_bar or c_bar)
	character*1 BCtype(Nb)			! BC type ('N' or 'D')
	integer ie(Ne,5)			! global connectivity array
	real*8 x(Nn,2)				! global coordinates array
	real*8 Soe(Ne,4)			! element independent source nodal values
	real*8 D(Ne,2,2)			! global  arrays
	real*8 C   (Nn)				! global  arrays
	real*8 vA(NnNd), vB(NnNd)		! global  arrays (compact values)
	real*8 xg(Ng), wg(Ng)			! Gauss abscissas [-1,+1] and weights

	integer i, e, m, p, ierror, i1, i2, i3, i4

	data ierror /0/
!	write(idbg,'(a)') ' --- READIN ---'	! ### TEMPORARY ###

! read input from inp.txt
	read (1,*) Sx 				! properties
	read (1,*) ipar(2), ipar(3), ipar(6)	! arguments needed to biCGstab
	read (1,*) fpar(1), fpar(2), fpar(11)	! arguments needed to biCGstab
	close(1)

	ipar(1) = 0				! initialize bCGstab
	ipar(4) = ldw				! work array dimension for bCGstab
	ipar(5) = 0				! unused for bCGstab

! reset all global arrays (ARRAY ASSIGNMENT)
	vA   = 0.
	rA   = 1
	cA   = 0
	vB   = 0.
	rB   = 1
	cB   = 0
! reset last indices for the sparse arrays
	lastA   = 0
	lastB   = 0

! read element connectivity form elements.txt
	open(1, file='elements.txt', status='old')
	do e = 1, Ne
	  read (1,*) i, (ie(e,m), m=1,5)	! element node 1 -node 4, mat
	enddo		! e
	close(1)

! read dispersion data from D.txt
	open(1, file='D.txt', status='old')
	do e = 1, Ne
	  read (1,*)  m, ((D(e,i,p), i=1,2), p=1,2)	! Dxx, Dxy, Dyx, Dyy
	enddo		! e
	close(1)

! read nodes data from nodes.txt
	open(1, file='nodes.txt', status='old')
! nodal coordinates & IC
	do i = 1, Nn
	  read (1,*) m, x(i,1), x(i,2), C(i)
	enddo		! i
	close(1)

! read element face BC data from BCs.txt
	open(1, file='BCs.txt', status='old')
!  BC face, BC element, BC type and 2 BC values at the BC element face nodes
	do i = 1, Nb
	  read (1,*) BCi(i), BCe(i,3), BCtype(i), BCvalue(i,1), BCvalue(i,2)
	enddo		! i
	close(1)

! read element independent source data from source.txt
	open(1, file='source.txt', status='old')
! 4 independent source values at the element nodes
	do e = 1, Ne
	  read (1,*) m, p, Soe(e,1), Soe(e,2), Soe(e,3), Soe(e,4)
	enddo		! e
	close(1)

	xg(2) = sqrt(1./3.d0)	! #### TEMPORARILY assume Ng = 2
	xg(1) = -xg(2)
	wg(1) = 1.d0
	wg(2) = 1.d0
! --------------------------------- ECHO INPUT ---------------------------------
	write(iout,*) 'Sx = ', Sx
	write(iout,*) 'ipar = ', ipar
	write(iout,*) 'fpar = ', fpar

	write(iout,*)  'i, xg(i), wg(i)'
	do i = 1, Ng
	  write(iout,*) i, xg(i), wg(i)
	enddo		! i
! --------------------------------- ECHO INPUT ---------------------------------

! write post-processing Gmsh file
! header
	write(ipost,'(a)') '$MeshFormat'
	write(ipost,'(a)') '2.2 0 8	// version-number file-type data-size'
	write(ipost,'(a)') '$EndMeshFormat'
	write(ipost,*)
! nodes
	write(ipost,'(a)') '$Nodes'
	write(ipost,'(i10, a)') Nn, '	// number-of-nodes'
	do i = 1, Nn
	  write(ipost,'(i10,3g)') i, x(i,1), x(i,2), 0.d0
	enddo		! i
	write(ipost,'(a)')  '// node-number x-coord y-coord z-coord'
	write(ipost,'(a)') '$EndNodes'
	write(ipost,*)
! elements
	write(ipost,'(a)') '$Elements'
	write(ipost,'(i10, a)') Ne, '	// number-of-elements'
	do e = 1, Ne
	  write(ipost,'(99i10)') e, 3, 1, ie(e,5), (ie(e,i),i=1,4)
	enddo		! i
	write(ipost,'(a)') '// elm-number elm-type number-of-tags < tag > ... node-number-list'
	write(ipost,'(a)') '$EndElements'
	write(ipost,*)
! diperssion tensor
	write(ipost,'(a)') '$ElementData'
	write(ipost,'(i10, a)') 1, '	// number-of-string-tags'
	write(ipost,'(a)') '"diperssion tensor"	// < "string-tag" > ...'
	write(ipost,'(i10, a)') 1, '	// number-of-real-tags'
	write(ipost,'(g, a)') 0.d0, '	// < real-tag > ... time'
	write(ipost,'(i10, a)') 3, '	// number-of-integer-tags'
	write(ipost,'(i10, a)') 0, '	// step #'
	write(ipost,'(i10, a)') 9, '	// number of components'
	write(ipost,'(i10, a)') Ne, '	// number of elements'
	do e = 1, Ne
	  write(ipost,'(i10, 9g)') e, (D(e,1,i), i=1,2), 0., &
				       (D(e,2,i), i=1,2), 0., 0., 0., 0.
	enddo		! e
	write(ipost,'(a)') '// elm-number number-of-nodes-per-element value ... Dxx, Dxy,.. Dzz'
	write(ipost,'(a)') '$EndElementData'
	write(ipost,*)

! check general input
	if(Sx .le. 0.) then
	  write(iout,*) '*** ABORT: Sx .le. 0'
	  ierror = ierror + 1
	endif
	if(Ng .ne. 2) then
	  write(iout,*) '*** ABORT: only Ng = 2 is currently allowed for'
	  ierror = ierror + 1
	endif
	if(fpar(1) .le. 0. .or. fpar(2) .le. 0.) then
	  write(iout,*) '*** ABORT: fpar(1) .le. 0. .or. fpar(2) .le. 0.'
	  ierror = ierror + 1
	endif
	if(ipar(2) .lt. 0 .or. ipar(2) .gt. 3) then
	  write(iout,*) '*** ABORT: ipar(2) .lt. 0 .or. ipar(2) .gt. 3'
	  ierror = ierror + 1
	endif
	if(ipar(3) .lt. -2 .or. ipar(2) .gt. 2) then
	  write(iout,*) '*** ABORT: ipar(3) .lt. -2 .or. ipar(2) .gt. 2'
	  ierror = ierror + 1
	endif
! check element input
	do e = 1, Ne
	  if(ie(e,1) .lt. 1 .or. ie(e,1) .gt. Nn .or. &
	     ie(e,2) .lt. 1 .or. ie(e,2) .gt. Nn .or. &
	     ie(e,3) .lt. 1 .or. ie(e,3) .gt. Nn .or. &
	     ie(e,4) .lt. 1 .or. ie(e,4) .gt. Nn .or. &
	     ie(e,5) .lt. 1 .or. ie(e,5) .gt. Nm ) then
	    write(iout,*) '*** ABORT: illegal ie(e,*), e, ie(e,*) = ', &
						       e, (ie(e,m), m=1,5)
	    ierror = ierror + 1
	  endif
	enddo		! e
	do e = 1, Ne
	  if(D(e,1,1).lt.0. .or. D(e,1,2).lt.0. .or. D(e,2,1).lt.0. .or. D(e,2,2).lt.0.) then
	    write(iout,*) '*** ABORT: D(e,i,j)<0 for e = ', e
	    ierror = ierror + 1
	  endif
	enddo		! e

! check BCs input
	do i = 1, Nb

	  if(BCe(i,3) .lt. 1 .or. BCe(i,3) .gt. Ne) then
	    write(iout,*) '*** ABORT: illegal BCe'
	    ierror = ierror + 1
	  endif

	  if(BCi(i) .lt. 1 .or. BCi(i) .gt. 4) then
	    write(iout,*) '*** ABORT: illegal BCi'
	    ierror = ierror + 1
	  endif

	  if( BCtype(i).ne.'N' .and. BCtype(i).ne.'D') then
	    write(iout,*) '*** ABORT: illegal i, BCtype(i) = ', i, BCtype(i)
	    ierror = ierror + 1
	  endif

	enddo		! i

	if(ierror .ne. 0) then
	  write(iout,*) '*** ABORT: ierror = ', ierror
	  stop
	endif
	
	return
	end

